
Public Class Form1

    Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As UInt32

    Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As UInt32, ByVal wMsg As UInt32, ByVal wParam As UInt32, ByVal lParam As UInt32) As UInt32

    Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hWnd As UInt32, ByVal wMsg As UInt32, ByVal wParam As UInt32, ByVal lParam As UInt32) As UInt32

    Public m_nDisplayTabNumber As UInt32 '0 = LIVE / 1 = RCPB / 2 = RTPB

    Public m_nDeviceSerialNumber As UInt32

    Public m_hVideoDev(0 To 3) As UInt32

    Public m_hVideoEncoderDev(0 To 3) As UInt32

    Public m_hAudioDev(0 To 3) As UInt32

    Public m_hFileRendererDev(0 To 3) As UInt32

    Public m_hFileRendererDualDev(0 To 3) As UInt32 'DUAL STORAGE [2010.06.08] [ISSUE#02]

    Public m_nFileRendererRecordState(0 To 3) As UInt32 '0 = STOP / 1 = ACQUIRE / 2 = START

    Public m_bFileRendererChangeNotify(0 To 3) As Boolean

    Public m_sFileRendererChangeSystemTime(0 To 3) As DateTime

    Public m_pFileRendererChangeDevName(0 To 3) As String

    Public m_pFileRendererChangeDualDevName(0 To 3) As String

    Public m_oFileRendererChangeMoniterLock(0 To 3) As Object

    Public m_hFileSourceDev(0 To 3) As UInt32

    Public m_hNetworkRendererDev As UInt32

    Public m_nNetworkRendererStreamingState(0 To 3) As UInt32 '0 = STOP / 1 = ACQUIRE / 2 = START

    Public m_hGpsSourceDev As UInt32 'GPS [2010.06.15] [ISSUE#04]

    Public m_pVideoBufferCB As AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK = Nothing

    Public m_pVideoEncoderBufferCB As AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK = Nothing

    Public m_pAudioBufferCB As AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK = Nothing

    Public m_cChannelControl_LIVE(0 To 3) As MyChannelControl 'LIVE (PREVIEW)

    Public m_cChannelControl_FILE(0 To 3) As MyChannelControl 'RCPB (RECORD PLAYBACK)

    Public m_cChannelControl_H264(0 To 3) As MyChannelControl 'RTPB (REALTIME PLAYBACK)

    Public m_cSetupControl As MySetupControl

    Public Function on_process_video_buffer(ByVal dSampleTime As Double, ByVal pBuffer As UInt32, ByVal nBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As UInt32

        Dim nChannelNumber As UInt32 = pUserData

        Dim i As UInt32 = nChannelNumber

        Dim hVideoDev As UInt32 = m_hVideoDev(i)

        Dim bIsVisible As UInt32 = 0

        Dim nLock As UInt32 = 0

        Dim nFps As UInt32 = 0

        AMESDK.NET.EXPORTS.AMESDK_GET_LOCK(hVideoDev, nLock)

        AMESDK.NET.EXPORTS.AMESDK_GET_FPS(hVideoDev, nFps)

        nLock = (nLock \ (2 ^ i)) And &H1

        'Debug.Print("CH" & i & ": LOCK = " & nLock & ", FPS =" & nFps) 'FOR DEBUG ONLY

        'AMESDK.NET.EXPORTS.AMESDK_OTHER_SNAPSHOT_JPG_EX(m_hVideoDev(i), "C:\SC290\CH" & (i + 1).ToString("D2") & "\TEMP.JPG", &H59565955, 352, 240, 16, 100) 'UYVY = &H59565955

        If m_nDisplayTabNumber = 0 Then bIsVisible = 1

        Return bIsVisible '1 = DISPLAY ON WINDOW

    End Function

    Public Function on_process_video_encoder_buffer(ByVal dSampleTime As Double, ByVal pBuffer As UInt32, ByVal nBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As UInt32

        Dim nChannelNumber As UInt32 = pUserData

        Dim i As UInt32 = nChannelNumber

        Dim hVideoEncoderDev As UInt32 = m_hVideoEncoderDev(i)

        Dim hFileRendererDev As UInt32 = m_hFileRendererDev(i)

        Dim hFileRendererDualDev As UInt32 = m_hFileRendererDualDev(i)

        Dim hNetworkRendererDev As UInt32 = m_hNetworkRendererDev

        Dim bIsRecord As Boolean = (m_nFileRendererRecordState(i) = 2)

        Dim bIsStreaming As Boolean = (m_nNetworkRendererStreamingState(i) = 2)

        Dim bIsVisible As UInt32 = 0

        If bIsKeyFrame Then

            If m_nFileRendererRecordState(i) = 1 Then

                m_nFileRendererRecordState(i) = 2

                bIsRecord = True

            End If

            If m_nNetworkRendererStreamingState(i) = 1 Then

                m_nNetworkRendererStreamingState(i) = 2

                bIsStreaming = True

            End If

            ' AUTO FILE SEGMENT (ON.TIMEOUT.EVENT)
            '
            Dim system_time As DateTime = DateTime.Now

            If (m_sFileRendererChangeSystemTime(i).Minute < 30 And system_time.Minute >= 30) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Minute >= 30 And system_time.Minute < 30) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Hour <> system_time.Hour) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Day <> system_time.Day) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Month <> system_time.Month) Or _
 _
               (m_sFileRendererChangeSystemTime(i).Year <> system_time.Year) Then

                m_sFileRendererChangeSystemTime(i) = system_time

                m_pFileRendererChangeDevName(i) = "Common Analog File Renderer C:\SC290\CH" & (i + 1).ToString("D2") & "\" & _
                                                                                              system_time.Year.ToString("D4") & _
                                                                                              system_time.Month.ToString("D2") & _
                                                                                              system_time.Day.ToString("D2") & _
                                                                                              system_time.Hour.ToString("D2") & _
                                                                                              system_time.Minute.ToString("D2") & _
                                                                                              system_time.Second.ToString("D2") & ".MP4"

                m_pFileRendererChangeDualDevName(i) = "Common Analog File Renderer D:\SC290.DUAL\CH" & (i + 1).ToString("D2") & "\" & _
                                                                                                       system_time.Year.ToString("D4") & _
                                                                                                       system_time.Month.ToString("D2") & _
                                                                                                       system_time.Day.ToString("D2") & _
                                                                                                       system_time.Hour.ToString("D2") & _
                                                                                                       system_time.Minute.ToString("D2") & _
                                                                                                       system_time.Second.ToString("D2") & ".MP4" 'DUAL STORAGE [2010.06.08] [ISSUE#02]
                System.Threading.Thread.VolatileWrite(m_bFileRendererChangeNotify(i), True)

            End If

            ' CHANGE CURRENT RECORD FILE (ON.FILE.CHANGE.EVENT)
            '
            If System.Threading.Thread.VolatileRead(m_bFileRendererChangeNotify(i)) Then

                Dim n_video_color_space_type As UInt32 = 0

                Dim n_video_frame_width As UInt32 = 0

                Dim n_video_frame_height As UInt32 = 0

                Dim n_video_frame_bit_count As UInt32 = 0

                Dim n_video_fps As Double = 0.0

                Dim n_video_custom_flags As UInt32 = 0

                Dim n_audio_steam_type As UInt32 = 0

                Dim n_audio_channels As UInt32 = 0

                Dim n_audio_bit_per_samlpe As UInt32 = 0

                Dim n_audio_samples_per_sec As UInt32 = 0

                System.Threading.Monitor.Enter(m_oFileRendererChangeMoniterLock(i))

                ' CLOSE CURRENT RECORD FILE
                '
                If (m_hFileRendererDev(i) And &H80000000) = &H0 Then

                    AMESDK.NET.EXPORTS.AMESDK_FILE_GET_VIDEO_STREAM_FORMAT(m_hFileRendererDev(i), n_video_color_space_type, n_video_frame_width, n_video_frame_height, n_video_frame_bit_count, n_video_fps, n_video_custom_flags)

                    AMESDK.NET.EXPORTS.AMESDK_FILE_GET_AUDIO_STREAM_FORMAT(m_hFileRendererDev(i), n_audio_steam_type, n_audio_channels, n_audio_bit_per_samlpe, n_audio_samples_per_sec)

                    AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hFileRendererDev(i))

                    m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

                End If

                If (m_hFileRendererDualDev(i) And &H80000000) = &H0 Then

                    AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hFileRendererDualDev(i))

                    m_hFileRendererDualDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

                End If

                ' UPDATE CURRENT FILE INFO LIST
                '
                Dim hWnd As Long = FindWindow(vbNullString, "Yuan's SC290N4 Live + H.264 Dual Stream Demo Software")

                PostMessage(hWnd, &H400, i, 0)

                Dim nDevNum As UInteger = 0

                Dim nDevType As UInteger = 3

                Dim nDisplayWindow As UInteger = 0

                Dim nUserData As UInteger = 0

                ' CREATE NEW RECORD FILE
                '
                nDevNum = 0

                m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(m_pFileRendererChangeDevName(i), i + nDevNum, nDevType, nDisplayWindow, Nothing, nUserData)

                nDevNum = 4

                m_hFileRendererDualDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(m_pFileRendererChangeDualDevName(i), i + nDevNum, nDevType, nDisplayWindow, Nothing, nUserData)

                If (m_hFileRendererDev(i) And &H80000000) = &H80000000 Then m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

                If (m_hFileRendererDualDev(i) And &H80000000) = &H80000000 Then m_hFileRendererDualDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

                AMESDK.NET.EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDev(i), n_video_color_space_type, n_video_frame_width, n_video_frame_height, n_video_frame_bit_count, n_video_fps, n_video_custom_flags)

                AMESDK.NET.EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDev(i), n_audio_steam_type, n_audio_channels, n_audio_bit_per_samlpe, n_audio_samples_per_sec)

                AMESDK.NET.EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDualDev(i), n_video_color_space_type, n_video_frame_width, n_video_frame_height, n_video_frame_bit_count, n_video_fps, n_video_custom_flags)

                AMESDK.NET.EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDualDev(i), n_audio_steam_type, n_audio_channels, n_audio_bit_per_samlpe, n_audio_samples_per_sec)

                System.Threading.Monitor.Exit(m_oFileRendererChangeMoniterLock(i))

                System.Threading.Thread.VolatileWrite(m_bFileRendererChangeNotify(i), False)

            End If

        End If

        If bIsRecord Then

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_BUFFER(hFileRendererDev, pBuffer, nBufferLen, bIsKeyFrame, 0, 0, Nothing, Nothing, Nothing, Nothing)

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_BUFFER(hFileRendererDualDev, pBuffer, nBufferLen, bIsKeyFrame, 0, 0, Nothing, Nothing, Nothing, Nothing)

        End If

        If bIsStreaming Then

            AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_BUFFER(hNetworkRendererDev, i, pBuffer, nBufferLen, bIsKeyFrame, 0, 0)

        End If

        If m_nDisplayTabNumber = 2 Then bIsVisible = 1

        Return bIsVisible '1 = DISPLAY ON WINDOW

    End Function

    Public Function on_process_audio_buffer(ByVal dSampleTime As Double, ByVal pBuffer As UInt32, ByVal nBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As UInt32

        Dim nChannelNumber As UInt32 = pUserData

        Dim i As UInt32 = nChannelNumber

        Dim hAudioDev As UInt32 = m_hAudioDev(i)

        Dim hFileRendererDev As UInt32 = m_hFileRendererDev(i)

        Dim hFileRendererDualDev As UInt32 = m_hFileRendererDualDev(i)

        Dim hNetworkRendererDev As UInt32 = m_hNetworkRendererDev

        Dim bIsRecord As Boolean = (m_nFileRendererRecordState(i) = 2)

        Dim bIsStreaming As Boolean = (m_nNetworkRendererStreamingState(i) = 2)

        Dim bIsMute As UInt32 = 0

        If bIsRecord Then

            System.Threading.Monitor.Enter(m_oFileRendererChangeMoniterLock(i))

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_BUFFER(m_hFileRendererDev(i), pBuffer, nBufferLen, 0, 0, Nothing)

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_BUFFER(m_hFileRendererDualDev(i), pBuffer, nBufferLen, 0, 0, Nothing)

            System.Threading.Monitor.Exit(m_oFileRendererChangeMoniterLock(i))

        End If

        If bIsStreaming Then

            AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_BUFFER(hNetworkRendererDev, i, pBuffer, nBufferLen, 0, 0)

        End If

        If m_nDisplayTabNumber = 0 Then bIsMute = 1

        If m_nDisplayTabNumber = 2 Then bIsMute = 1

        Return bIsMute

    End Function

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Dim i As UInt32 = 0

        'USER INTERFACE PROGRAMMING (MAIN FORM)
        '
        Dim BorderSize As System.Drawing.Size = Me.Size - Me.ClientSize

        Me.Width = BorderSize.Width + 704

        Me.Height = BorderSize.Height + 480

        For i = 0 To 3

            m_cChannelControl_LIVE(i) = New MyChannelControl()
            m_cChannelControl_FILE(i) = New MyChannelControl()
            m_cChannelControl_H264(i) = New MyChannelControl()

            m_cChannelControl_LIVE(i).Parent = Me
            m_cChannelControl_FILE(i).Parent = Me
            m_cChannelControl_H264(i).Parent = Me

            If i = 0 Then m_cChannelControl_LIVE(i).Left = 0
            If i = 0 Then m_cChannelControl_FILE(i).Left = 0
            If i = 0 Then m_cChannelControl_H264(i).Left = 0

            If i = 1 Then m_cChannelControl_LIVE(i).Left = 352
            If i = 1 Then m_cChannelControl_FILE(i).Left = 352
            If i = 1 Then m_cChannelControl_H264(i).Left = 352

            If i = 2 Then m_cChannelControl_LIVE(i).Left = 0
            If i = 2 Then m_cChannelControl_FILE(i).Left = 0
            If i = 2 Then m_cChannelControl_H264(i).Left = 0

            If i = 3 Then m_cChannelControl_LIVE(i).Left = 352
            If i = 3 Then m_cChannelControl_FILE(i).Left = 352
            If i = 3 Then m_cChannelControl_H264(i).Left = 352

            If i = 0 Then m_cChannelControl_LIVE(i).Top = 0
            If i = 0 Then m_cChannelControl_FILE(i).Top = 0
            If i = 0 Then m_cChannelControl_H264(i).Top = 0

            If i = 1 Then m_cChannelControl_LIVE(i).Top = 0
            If i = 1 Then m_cChannelControl_FILE(i).Top = 0
            If i = 1 Then m_cChannelControl_H264(i).Top = 0

            If i = 2 Then m_cChannelControl_LIVE(i).Top = 240
            If i = 2 Then m_cChannelControl_FILE(i).Top = 240
            If i = 2 Then m_cChannelControl_H264(i).Top = 240

            If i = 3 Then m_cChannelControl_LIVE(i).Top = 240
            If i = 3 Then m_cChannelControl_FILE(i).Top = 240
            If i = 3 Then m_cChannelControl_H264(i).Top = 240

            m_cChannelControl_LIVE(i).Size = New System.Drawing.Size(352, 240)
            m_cChannelControl_FILE(i).Size = New System.Drawing.Size(352, 240)
            m_cChannelControl_H264(i).Size = New System.Drawing.Size(352, 240)

            m_cChannelControl_LIVE(i).Visible = True
            m_cChannelControl_FILE(i).Visible = False
            m_cChannelControl_H264(i).Visible = False

            m_cChannelControl_LIVE(i).m_nChannelNumber = i + &H10000000
            m_cChannelControl_FILE(i).m_nChannelNumber = i + &H20000000
            m_cChannelControl_H264(i).m_nChannelNumber = i + &H40000000

        Next

        For i = 0 To 3

            m_hVideoDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hVideoEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hAudioDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hFileRendererDualDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_nFileRendererRecordState(i) = 0

            System.Threading.Thread.VolatileWrite(m_bFileRendererChangeNotify(i), False)

            m_sFileRendererChangeSystemTime(i) = DateTime.Now

            m_pFileRendererChangeDevName(i) = ""

            m_pFileRendererChangeDualDevName(i) = ""

            m_hFileSourceDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hNetworkRendererDev = 4294967295 '4294967295 = &HFFFFFFFF

            m_nNetworkRendererStreamingState(i) = 0

            m_hGpsSourceDev = 4294967295 '4294967295 = &HFFFFFFFF

        Next

        m_pVideoBufferCB = New AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK(AddressOf on_process_video_buffer)

        m_pVideoEncoderBufferCB = New AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK(AddressOf on_process_video_encoder_buffer)

        m_pAudioBufferCB = New AMESDK.NET.EXPORTS.PF_BUFFER_CALLBACK(AddressOf on_process_audio_buffer)

        m_oFileRendererChangeMoniterLock(0) = New Object

        m_oFileRendererChangeMoniterLock(1) = New Object

        m_oFileRendererChangeMoniterLock(2) = New Object

        m_oFileRendererChangeMoniterLock(3) = New Object

        m_nDisplayTabNumber = 0

        'USER INTERFACE PROGRAMMING (SETUP CONTROL)
        '
        m_cSetupControl = New MySetupControl()

        m_cSetupControl.m_pMainForm = Me

        BorderSize = m_cSetupControl.Size - m_cSetupControl.ClientSize

        Me.Top = Me.Top - 75

        m_cSetupControl.Top = Me.Bottom + 5

        m_cSetupControl.Left = Me.Left - ((1248 - 704 - BorderSize.Width) / 2)

        m_cSetupControl.Width = 0

        m_cSetupControl.Height = 0

        m_cSetupControl.Visible = False

        m_cSetupControl.Show()

        m_cSetupControl.Visible = False

        HwInitialize()

        m_cSetupControl.Width = BorderSize.Width + 1248

        m_cSetupControl.Height = BorderSize.Height + 25 * 7

        m_cSetupControl.Visible = True

    End Sub

    Private Sub Form1_Closed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        HwUninitialize()

        m_cSetupControl.Close()

    End Sub

    Public Function HwInitialize() As Boolean

        'GET DEVICE PARAMETERS FROM SETUP DIALOG
        '
        Dim std As UInt32

        Dim cx(0 To 3) As UInt32

        Dim cy(0 To 3) As UInt32

        Dim fps(0 To 3) As Double

        Dim deinterlace(0 To 3) As UInt32

        Dim rcmode(0 To 3) As UInt32

        Dim bitrate(0 To 3) As UInt32

        Dim quality(0 To 3) As UInt32

        Dim gop(0 To 3) As UInt32

        Dim qpstep(0 To 3) As UInt32

        Dim peakbitrate(0 To 3) As UInt32

        Dim troughquality(0 To 3) As UInt32

        Dim i As UInt32

        Dim nDevNum As UInteger = 0

        Dim nDevType As UInteger = 8

        Dim nDisplayWindow As UInteger = 0

        Dim nUserData As UInteger = 0

        m_cSetupControl.GetStandardParameter(std)

        m_cSetupControl.GetResolutionParameter(cx, cy)

        m_cSetupControl.GetFrameRateParameter(fps)

        m_cSetupControl.GetDeinterlaceParameter(deinterlace)

        m_cSetupControl.GetRecordModeParameter(rcmode)

        m_cSetupControl.GetBitRateParameter(bitrate)

        m_cSetupControl.GetQualityParameter(quality)

        m_cSetupControl.GetGOPParameter(gop)

        m_cSetupControl.GetQPStepParameter(qpstep)

        m_cSetupControl.GetPeakBitRateParameter(peakbitrate)

        m_cSetupControl.GetTroughQualityParameter(troughquality)

        'INITIALIZE GPS SOURCE [2010.06.15] [ISSUE#04]
        '
        m_hGpsSourceDev = AMESDK.NET.EXPORTS.AMESDK_CREATE("Common Analog GPS Source port=com3 baudrate=4800", nDevNum, nDevType, nDisplayWindow, Nothing, nUserData)

        If (m_hGpsSourceDev And &H80000000) = &H80000000 Then m_hGpsSourceDev = 4294967295 '4294967295 = &HFFFFFFFF

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hGpsSourceDev)

        'INITIALIZE NETWORK RENDERERS (RTSP)
        '
        m_hNetworkRendererDev = 4294967295 '4294967295 = &HFFFFFFFF

        nDevType = 5

        m_hNetworkRendererDev = AMESDK.NET.EXPORTS.AMESDK_CREATE("Common Analog Network Renderer streams=4", nDevNum, nDevType, nDisplayWindow, Nothing, nUserData)

        If (m_hNetworkRendererDev And &H80000000) = &H80000000 Then m_hNetworkRendererDev = 4294967295 '4294967295 = &HFFFFFFFF

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 0, &H34363248, cx(0), cy(0), 24, fps(0), bitrate(0) * 4) 'H264 = &H34363248

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 1, &H34363248, cx(1), cy(1), 24, fps(1), bitrate(1) * 4) 'H264 = &H34363248

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 2, &H34363248, cx(2), cy(2), 24, fps(2), bitrate(2) * 4) 'H264 = &H34363248

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 3, &H34363248, cx(3), cy(3), 24, fps(3), bitrate(3) * 4) 'H264 = &H34363248

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 0, 0, 1, 16, 8000, 1 * 16 * 8000 * 4)

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 1, 0, 1, 16, 8000, 1 * 16 * 8000 * 4)

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 2, 0, 1, 16, 8000, 1 * 16 * 8000 * 4)

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 3, 0, 1, 16, 8000, 1 * 16 * 8000 * 4)

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_USER_ACCOUNT(m_hNetworkRendererDev, "root", "root")

        AMESDK.NET.EXPORTS.AMESDK_NETWORK_SET_STREAMING_PORT(m_hNetworkRendererDev, 554)

        'INITIALIZE FILE RENDERERS
        '
        For i = 0 To 3

            Dim system_time As DateTime = DateTime.Now

            Dim file_path As String

            Dim file_path_dual As String

            m_sFileRendererChangeSystemTime(i) = system_time

            file_path = "Common Analog File Renderer C:\SC290\CH" & (i + 1).ToString("D2") & "\" & _
                                                                    system_time.Year.ToString("D4") & _
                                                                    system_time.Month.ToString("D2") & _
                                                                    system_time.Day.ToString("D2") & _
                                                                    system_time.Hour.ToString("D2") & _
                                                                    system_time.Minute.ToString("D2") & _
                                                                    system_time.Second.ToString("D2") & ".MP4"

            file_path_dual = "Common Analog File Renderer D:\SC290.DUAL\CH" & (i + 1).ToString("D2") & "\" & _
                                                                              system_time.Year.ToString("D4") & _
                                                                              system_time.Month.ToString("D2") & _
                                                                              system_time.Day.ToString("D2") & _
                                                                              system_time.Hour.ToString("D2") & _
                                                                              system_time.Minute.ToString("D2") & _
                                                                              system_time.Second.ToString("D2") & ".MP4" 'DUAL STORAGE [2010.06.08] [ISSUE#02]
            m_pFileRendererChangeDevName(i) = file_path

            m_pFileRendererChangeDualDevName(i) = file_path_dual

            m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hFileRendererDualDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            nDevType = 3

            nDisplayWindow = 0

            nUserData = 0

            If i = 0 Then m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path, i, nDevType, nDisplayWindow, Nothing, nUserData)

            If i = 1 Then m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path, i, nDevType, nDisplayWindow, Nothing, nUserData)

            If i = 2 Then m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path, i, nDevType, nDisplayWindow, Nothing, nUserData)

            If i = 3 Then m_hFileRendererDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path, i, nDevType, nDisplayWindow, Nothing, nUserData)

            nDevNum = 4

            If i = 0 Then m_hFileRendererDualDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path_dual, nDevNum, nDevType, nDisplayWindow, Nothing, nUserData)

            nDevNum = 5

            If i = 1 Then m_hFileRendererDualDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path_dual, nDevNum, nDevType, nDisplayWindow, Nothing, nUserData)

            nDevNum = 6

            If i = 2 Then m_hFileRendererDualDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path_dual, nDevNum, nDevType, nDisplayWindow, Nothing, nUserData)

            nDevNum = 7

            If i = 3 Then m_hFileRendererDualDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE(file_path_dual, nDevNum, nDevType, nDisplayWindow, Nothing, nUserData)

            If (m_hFileRendererDev(i) And &H80000000) = &H80000000 Then m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            If (m_hFileRendererDualDev(i) And &H80000000) = &H80000000 Then m_hFileRendererDualDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            Dim custom_flags As UInt32 = &H0

            If cy(i) = 480 Then custom_flags = &H100 ' &H00000100 = AMESDK_FILE_CUSTOMFLAFS_ISITEERLEAVED

            If cy(i) = 576 Then custom_flags = &H100 ' &H00000100 = AMESDK_FILE_CUSTOMFLAFS_ISITEERLEAVED

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDev(i), &H34363248, cx(i), cy(i), 24, fps(i), custom_flags) 'H264 = &H34363248

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDualDev(i), &H34363248, cx(i), cy(i), 24, fps(i), custom_flags) 'H264 = &H34363248

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDev(i), 0, 1, 16, 8000)

            AMESDK.NET.EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDualDev(i), 0, 1, 16, 8000)

        Next

        nDevType = 0

        'INITIALIZE VIDEO STREAMS (UYVY)
        '
        For i = 0 To 3

            m_hVideoDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            If i = 0 Then m_hVideoDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI", i, nDevType, CType(m_cChannelControl_LIVE(0).Handle, UInteger), m_pVideoBufferCB, i)

            If i = 1 Then m_hVideoDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI", i, nDevType, CType(m_cChannelControl_LIVE(1).Handle, UInteger), m_pVideoBufferCB, i)

            If i = 2 Then m_hVideoDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI", i, nDevType, CType(m_cChannelControl_LIVE(2).Handle, UInteger), m_pVideoBufferCB, i)

            If i = 3 Then m_hVideoDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI", i, nDevType, CType(m_cChannelControl_LIVE(3).Handle, UInteger), m_pVideoBufferCB, i)

            If (m_hVideoDev(i) And &H80000000) = &H80000000 Then m_hVideoDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            If std And &H1 Then

                AMESDK.NET.EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev(i), &H1) 'NTSC = &H00000001 / PAL = &H00000010

                AMESDK.NET.EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev(i), &H59565955, 352, 240, 16, 29.97) 'UYVY = &H59565955

                AMESDK.NET.EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev(i), 0) 'NOTE!! 352  240 IS PROGRESSIVE FIELD FORMAT

            Else

                AMESDK.NET.EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev(i), &H10) 'NTSC = &H00000001 / PAL = &H00000010

                AMESDK.NET.EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev(i), &H59565955, 352, 288, 16, 25.0) 'UYVY = &H59565955

                AMESDK.NET.EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev(i), 0) 'NOTE!! 352  288 IS PROGRESSIVE FIELD FORMAT

            End If

            If i = 0 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev(i), 0, 0)

            If i = 1 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev(i), 0, 0)

            If i = 2 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev(i), 1, 0)

            If i = 3 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev(i), 1, 0)

            Dim n_device_serial_number As UInt32 = 0

            Dim n_video_standard As UInt32 = 0

            Dim n_video_colorspace As UInt32 = 0

            Dim n_video_width As UInt32 = 0

            Dim n_video_height As UInt32 = 0

            Dim n_video_bitcount As UInt32 = 0

            Dim d_video_framerate As Double = 0

            Dim n_video_deinterlace As UInt32 = 0

            Dim n_video_horizontal_mirror As UInt32 = 0

            Dim n_video_vertical_mirror As UInt32 = 0

            AMESDK.NET.EXPORTS.AMESDK_GET_CUSTOM_PROPERTY(m_hVideoDev(i), 0, n_device_serial_number)

            AMESDK.NET.EXPORTS.AMESDK_GET_STANDARD(m_hVideoDev(i), n_video_standard)

            AMESDK.NET.EXPORTS.AMESDK_GET_FORMAT(m_hVideoDev(i), n_video_colorspace, n_video_width, n_video_height, n_video_bitcount, d_video_framerate)

            AMESDK.NET.EXPORTS.AMESDK_GET_DEINTERLACE(m_hVideoDev(i), n_video_deinterlace)

            AMESDK.NET.EXPORTS.AMESDK_GET_MIRROR(m_hVideoDev(i), n_video_horizontal_mirror, n_video_vertical_mirror)

        Next

        nDevType = 0

        'INITIALIZE VIDEO ENCODER STREAMS (H.264)
        '
        For i = 0 To 3

            m_hVideoEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            If i = 0 Then m_hVideoEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264(0).Handle, UInteger), m_pVideoEncoderBufferCB, i)

            If i = 1 Then m_hVideoEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264(1).Handle, UInteger), m_pVideoEncoderBufferCB, i)

            If i = 2 Then m_hVideoEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264(2).Handle, UInteger), m_pVideoEncoderBufferCB, i)

            If i = 3 Then m_hVideoEncoderDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI, Analog Encoder", i, nDevType, CType(m_cChannelControl_H264(3).Handle, UInteger), m_pVideoEncoderBufferCB, i)

            If (m_hVideoEncoderDev(i) And &H80000000) = &H80000000 Then m_hVideoEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            AMESDK.NET.EXPORTS.AMESDK_SET_STANDARD(m_hVideoEncoderDev(i), std) 'NTSC = &H00000001 / PAL = &H00000010

            AMESDK.NET.EXPORTS.AMESDK_SET_FORMAT(m_hVideoEncoderDev(i), &H34363248, cx(i), cy(i), 24, fps(i)) 'H264 = &H34363248

            AMESDK.NET.EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoEncoderDev(i), deinterlace(i)) 'DISABLE = &H00000000 / BEST = &H00000007

            If i = 0 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoEncoderDev(i), 0, 0)

            If i = 1 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoEncoderDev(i), 0, 0)

            If i = 2 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoEncoderDev(i), 1, 0)

            If i = 3 Then AMESDK.NET.EXPORTS.AMESDK_SET_MIRROR(m_hVideoEncoderDev(i), 1, 0)

            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 3, rcmode(i)) 'RECORD MODE

            If rcmode(i) = 0 Then 'VBR

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 1, quality(i)) 'QUALITY

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 0, gop(i)) 'GOP

            End If

            If rcmode(i) = 1 Then 'CBR

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 4, bitrate(i)) 'BITRATE

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 0, gop(i)) 'GOP

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 5, qpstep(i)) 'QPSTEP

            End If

            If rcmode(i) = 2 Then 'HBR

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 4, bitrate(i)) 'BITRATE

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 1, quality(i)) 'QUALITY

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 0, gop(i)) 'GOP

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 5, qpstep(i)) 'QPSTEP

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 6, peakbitrate(i)) 'PEAK BITRATE

                AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 7, troughquality(i)) 'TROUGH QUALITY

            End If

            If fps(i) = (29.97 / 1) Then AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 9, 0) 'POST FRAMERATE [2010.06.08] [ISSUE#03]

            If fps(i) = (29.97 / 2) Then AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 9, 1) 'POST FRAMERATE [2010.06.08] [ISSUE#03]

            If fps(i) = (29.97 / 4) Then AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 9, 3) 'POST FRAMERATE [2010.06.08] [ISSUE#03]

            If fps(i) = (29.97 / 8) Then AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 9, 7) 'POST FRAMERATE [2010.06.08] [ISSUE#03]

            If fps(i) = (25.0 / 1) Then AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 9, 0) 'POST FRAMERATE [2010.06.08] [ISSUE#03]

            If fps(i) = (29.0 / 2) Then AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 9, 1) 'POST FRAMERATE [2010.06.08] [ISSUE#03]

            If fps(i) = (29.0 / 4) Then AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 9, 3) 'POST FRAMERATE [2010.06.08] [ISSUE#03]

            If fps(i) = (29.0 / 8) Then AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoEncoderDev(i), 9, 7) 'POST FRAMERATE [2010.06.08] [ISSUE#03]

        Next

        nDevType = 0

        nDisplayWindow = 0

        nUserData = 0

        'INITIALIZE AUDIO STREAMS (PCM)
        '
        For i = 0 To 3

            m_hAudioDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            If i = 0 Then m_hAudioDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI, Analog WaveIn", i, nDevType, nDisplayWindow, m_pAudioBufferCB, i)

            If i = 1 Then m_hAudioDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI, Analog WaveIn", i, nDevType, nDisplayWindow, m_pAudioBufferCB, i)

            If i = 2 Then m_hAudioDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI, Analog WaveIn", i, nDevType, nDisplayWindow, m_pAudioBufferCB, i)

            If i = 3 Then m_hAudioDev(i) = AMESDK.NET.EXPORTS.AMESDK_CREATE("AH8400 PCI, Analog WaveIn", i, nDevType, nDisplayWindow, m_pAudioBufferCB, i)

            If (m_hAudioDev(i) And &H80000000) = &H80000000 Then m_hAudioDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            Dim n_audio_channels As UInt32 = 0

            Dim n_audio_bits_per_sample As UInt32 = 0

            Dim n_audio_samples_per_sec As UInt32 = 0

            AMESDK.NET.EXPORTS.AMESDK_SET_FORMAT(m_hAudioDev(i), 1, 16, 8000)

            AMESDK.NET.EXPORTS.AMESDK_GET_FORMAT(m_hAudioDev(i), n_audio_channels, n_audio_bits_per_sample, n_audio_samples_per_sec)

        Next

        'SET CUSTOM OSD PROPERTY [2010.06.08] [ISSUE#01]
        '  
        Dim OSD00() As Byte = New Byte(0 To 32) {Asc("1"), Asc("2"), Asc("3"), Asc("4"), Asc("5"), Asc("6"), Asc("7"), Asc("8"), Asc("9"), Asc("0"), _
                                                 Asc("1"), Asc("2"), Asc("3"), Asc("4"), Asc("5"), Asc("6"), Asc("7"), Asc("8"), Asc("9"), Asc("0"), _
                                                 Asc("1"), Asc("2"), Asc("3"), Asc("4"), Asc("5"), Asc("6"), Asc("7"), Asc("8"), Asc("9"), Asc("0"), _
                                                 Asc("1"), Asc("2"), 0}

        Dim OSD01() As Byte = New Byte(0 To 10) {Asc("1"), Asc("2"), Asc("3"), Asc("4"), Asc("5"), Asc("6"), Asc("7"), Asc("8"), Asc("9"), Asc("0"), 0}

        Dim OSD02() As Byte = New Byte(0 To 10) {Asc("1"), Asc("2"), Asc("3"), Asc("4"), Asc("5"), Asc("6"), Asc("7"), Asc("8"), Asc("9"), Asc("0"), 0}

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoEncoderDev(0), 920, 0)

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoEncoderDev(0), 921, AMESDK.NET.EXPORTS.HELPER_OBJPTR(OSD00(0)), 32 + 1)

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoEncoderDev(0), 920, 1)

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoEncoderDev(0), 921, AMESDK.NET.EXPORTS.HELPER_OBJPTR(OSD01(0)), 10 + 1)

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoEncoderDev(0), 920, 2)

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoEncoderDev(0), 921, AMESDK.NET.EXPORTS.HELPER_OBJPTR(OSD02(0)), 10 + 1)

        'GET/SET CUSTOM GPIO PROPERTY [2010.06.08] [ISSUE#05] [ISSUE#06]
        ' 
        Dim gpio_inputs As UInt32 = &HF0

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoEncoderDev(0), 940, &HF0) 'GPIO DIRECTION: INPUT [0:3] & OUTPUT [4:7]

        AMESDK.NET.EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoEncoderDev(0), 941, &HF0) 'GPIO DATA: OUTPUT [4:7]

        AMESDK.NET.EXPORTS.AMESDK_GET_CUSTOM_PROPERTY(m_hVideoEncoderDev(0), 941, gpio_inputs) 'GPIO DATA: INPUT [0:3]

        gpio_inputs = gpio_inputs And &HF 'GPIO DATA: INPUT [0:3]

        'GET DEVICE SERIAL NUMBER
        '  
        AMESDK.NET.EXPORTS.AMESDK_GET_CUSTOM_PROPERTY(m_hVideoDev(0), 0, m_nDeviceSerialNumber)

        ' DEVICE RUN
        '
        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoDev(0))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoDev(1))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoDev(2))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoDev(3))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoEncoderDev(0))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoEncoderDev(1))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoEncoderDev(2))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hVideoEncoderDev(3))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hAudioDev(0))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hAudioDev(1))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hAudioDev(2))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hAudioDev(3))

        AMESDK.NET.EXPORTS.AMESDK_RUN(m_hNetworkRendererDev)

        m_nFileRendererRecordState(0) = 1 'ACQUIRE RECORDING

        m_nFileRendererRecordState(1) = 1 'ACQUIRE RECORDING

        m_nFileRendererRecordState(2) = 1 'ACQUIRE RECORDING

        m_nFileRendererRecordState(3) = 1 'ACQUIRE RECORDING

        m_nNetworkRendererStreamingState(0) = 1 'START STREAMING

        m_nNetworkRendererStreamingState(1) = 1 'START STREAMING

        m_nNetworkRendererStreamingState(2) = 1 'START STREAMING

        m_nNetworkRendererStreamingState(3) = 1 'START STREAMING

    End Function

    Public Function HwUninitialize() As Boolean

        m_nNetworkRendererStreamingState(0) = 0 'STOP STREAMING

        m_nNetworkRendererStreamingState(1) = 0 'STOP STREAMING

        m_nNetworkRendererStreamingState(2) = 0 'STOP STREAMING

        m_nNetworkRendererStreamingState(3) = 0 'STOP STREAMING

        m_nFileRendererRecordState(0) = 0 'STOP RECORDING

        m_nFileRendererRecordState(1) = 0 'STOP RECORDING

        m_nFileRendererRecordState(2) = 0 'STOP RECORDING

        m_nFileRendererRecordState(3) = 0 'STOP RECORDING

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoDev(0))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoDev(1))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoDev(2))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoDev(3))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoEncoderDev(0))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoEncoderDev(1))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoEncoderDev(2))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hVideoEncoderDev(3))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hAudioDev(0))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hAudioDev(1))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hAudioDev(2))

        AMESDK.NET.EXPORTS.AMESDK_STOP(m_hAudioDev(3))

        Dim i As UInt32 = 0

        For i = 0 To 3

            If (m_hVideoDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hVideoDev(i))

            If (m_hVideoEncoderDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hVideoEncoderDev(i))

            If (m_hAudioDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hAudioDev(i))

            If (m_hFileRendererDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hFileRendererDev(i))

            If (m_hFileRendererDualDev(i) And &H80000000) = &H0 Then AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hFileRendererDualDev(i))

            m_hVideoDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hVideoEncoderDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hAudioDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hFileRendererDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

            m_hFileRendererDualDev(i) = 4294967295 '4294967295 = &HFFFFFFFF

        Next

        AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hNetworkRendererDev)

        m_hNetworkRendererDev = 4294967295 '4294967295 = &HFFFFFFFF

        AMESDK.NET.EXPORTS.AMESDK_DESTROY(m_hGpsSourceDev)

        m_hGpsSourceDev = 4294967295 '4294967295 = &HFFFFFFFF

    End Function

    Public Sub OnLButtonDown_ChannelControl(ByVal nChannelNumber As UInt32)

        If nChannelNumber And &H10000000 Then 'LIVE PATH

            Dim i As UInt32 = nChannelNumber - &H10000000

            If m_cChannelControl_LIVE(i).Size.Height() > 360 Then

                If i = 0 Then m_cChannelControl_LIVE(i).Left = 0
                If i = 1 Then m_cChannelControl_LIVE(i).Left = 352
                If i = 2 Then m_cChannelControl_LIVE(i).Left = 0
                If i = 3 Then m_cChannelControl_LIVE(i).Left = 352
                If i = 0 Then m_cChannelControl_LIVE(i).Top = 0
                If i = 1 Then m_cChannelControl_LIVE(i).Top = 0
                If i = 2 Then m_cChannelControl_LIVE(i).Top = 240
                If i = 3 Then m_cChannelControl_LIVE(i).Top = 240

                m_cChannelControl_LIVE(i).Size = New System.Drawing.Size(352, 240)

                m_cChannelControl_LIVE(0).Visible = True
                m_cChannelControl_LIVE(1).Visible = True
                m_cChannelControl_LIVE(2).Visible = True
                m_cChannelControl_LIVE(3).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev(i))

            Else

                m_cChannelControl_LIVE(i).Left = 0
                m_cChannelControl_LIVE(i).Top = 0
                m_cChannelControl_LIVE(i).Size = New System.Drawing.Size(704, 480)

                m_cChannelControl_LIVE(0).Visible = False
                m_cChannelControl_LIVE(1).Visible = False
                m_cChannelControl_LIVE(2).Visible = False
                m_cChannelControl_LIVE(3).Visible = False
                m_cChannelControl_LIVE(i).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev(i))

            End If

        End If

        If nChannelNumber And &H20000000 Then 'RCPB PATH

            Dim i As UInt32 = nChannelNumber - &H20000000

            If m_cChannelControl_FILE(i).Size.Height() > 360 Then

                If i = 0 Then m_cChannelControl_FILE(i).Left = 0
                If i = 1 Then m_cChannelControl_FILE(i).Left = 352
                If i = 2 Then m_cChannelControl_FILE(i).Left = 0
                If i = 3 Then m_cChannelControl_FILE(i).Left = 352

                If i = 0 Then m_cChannelControl_FILE(i).Top = 0
                If i = 1 Then m_cChannelControl_FILE(i).Top = 0
                If i = 2 Then m_cChannelControl_FILE(i).Top = 240
                If i = 3 Then m_cChannelControl_FILE(i).Top = 240

                m_cChannelControl_FILE(i).Size = New System.Drawing.Size(352, 240)

                m_cChannelControl_FILE(0).Visible = True
                m_cChannelControl_FILE(1).Visible = True
                m_cChannelControl_FILE(2).Visible = True
                m_cChannelControl_FILE(3).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev(i))

            Else

                m_cChannelControl_FILE(i).Left = 0
                m_cChannelControl_FILE(i).Top = 0
                m_cChannelControl_FILE(i).Size = New System.Drawing.Size(704, 480)

                m_cChannelControl_FILE(0).Visible = False
                m_cChannelControl_FILE(1).Visible = False
                m_cChannelControl_FILE(2).Visible = False
                m_cChannelControl_FILE(3).Visible = False
                m_cChannelControl_FILE(i).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev(i))

            End If

        End If

        If nChannelNumber And &H40000000 Then 'RTPB PATH

            Dim i As UInt32 = nChannelNumber - &H40000000

            If m_cChannelControl_H264(i).Size.Height() > 360 Then

                If i = 0 Then m_cChannelControl_H264(i).Left = 0
                If i = 1 Then m_cChannelControl_H264(i).Left = 352
                If i = 2 Then m_cChannelControl_H264(i).Left = 0
                If i = 3 Then m_cChannelControl_H264(i).Left = 352

                If i = 0 Then m_cChannelControl_H264(i).Top = 0
                If i = 1 Then m_cChannelControl_H264(i).Top = 0
                If i = 2 Then m_cChannelControl_H264(i).Top = 240
                If i = 3 Then m_cChannelControl_H264(i).Top = 240

                m_cChannelControl_H264(i).Size = New System.Drawing.Size(352, 240)

                m_cChannelControl_H264(0).Visible = True
                m_cChannelControl_H264(1).Visible = True
                m_cChannelControl_H264(2).Visible = True
                m_cChannelControl_H264(3).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoEncoderDev(i))

            Else

                m_cChannelControl_H264(i).Left = 0
                m_cChannelControl_H264(i).Top = 0
                m_cChannelControl_H264(i).Size = New System.Drawing.Size(704, 480)

                m_cChannelControl_H264(0).Visible = False
                m_cChannelControl_H264(1).Visible = False
                m_cChannelControl_H264(2).Visible = False
                m_cChannelControl_H264(3).Visible = False
                m_cChannelControl_H264(i).Visible = True

                AMESDK.NET.EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoEncoderDev(i))

            End If

        End If

    End Sub

    Public Sub OnCheckedChanged_RadioButton_SetupControl(ByVal nRadioButtonNumber As UInt32)

        If nRadioButtonNumber = 0 Then 'LIVE PATH

            m_nDisplayTabNumber = 0

            m_cChannelControl_LIVE(0).Visible = True
            m_cChannelControl_LIVE(1).Visible = True
            m_cChannelControl_LIVE(2).Visible = True
            m_cChannelControl_LIVE(3).Visible = True
            m_cChannelControl_FILE(0).Visible = False
            m_cChannelControl_FILE(1).Visible = False
            m_cChannelControl_FILE(2).Visible = False
            m_cChannelControl_FILE(3).Visible = False
            m_cChannelControl_H264(0).Visible = False
            m_cChannelControl_H264(1).Visible = False
            m_cChannelControl_H264(2).Visible = False
            m_cChannelControl_H264(3).Visible = False

        End If

        If nRadioButtonNumber = 1 Then 'RCPB PATH

            m_nDisplayTabNumber = 1

            m_cChannelControl_FILE(0).Visible = True
            m_cChannelControl_FILE(1).Visible = True
            m_cChannelControl_FILE(2).Visible = True
            m_cChannelControl_FILE(3).Visible = True
            m_cChannelControl_LIVE(0).Visible = False
            m_cChannelControl_LIVE(1).Visible = False
            m_cChannelControl_LIVE(2).Visible = False
            m_cChannelControl_LIVE(3).Visible = False
            m_cChannelControl_H264(0).Visible = False
            m_cChannelControl_H264(1).Visible = False
            m_cChannelControl_H264(2).Visible = False
            m_cChannelControl_H264(3).Visible = False

        End If

        If nRadioButtonNumber = 2 Then 'RTPB PATH

            m_nDisplayTabNumber = 2

            m_cChannelControl_H264(0).Visible = True
            m_cChannelControl_H264(1).Visible = True
            m_cChannelControl_H264(2).Visible = True
            m_cChannelControl_H264(3).Visible = True
            m_cChannelControl_LIVE(0).Visible = False
            m_cChannelControl_LIVE(1).Visible = False
            m_cChannelControl_LIVE(2).Visible = False
            m_cChannelControl_LIVE(3).Visible = False
            m_cChannelControl_FILE(0).Visible = False
            m_cChannelControl_FILE(1).Visible = False
            m_cChannelControl_FILE(2).Visible = False
            m_cChannelControl_FILE(3).Visible = False

        End If

    End Sub

    Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)

        If m.Msg = &H14 Then '&H00000014 = WM_ERASEBKGND

            Return

        End If

        If m.Msg = &H400 Then '&H00000400 = WM_USER (UPDATE FILE INFO LIST)

            Dim system_time As DateTime = DateTime.Now

            Dim start_search_system_time As DateTime = New DateTime(system_time.Year, system_time.Month, system_time.Day)

            Dim stop_search_system_time As DateTime = New DateTime(system_time.Year, system_time.Month, system_time.Day, 23, 59, 59, 999)

            Dim n_start_search_systemtime As UInt64 = start_search_system_time.ToFileTimeUtc()

            Dim n_stop_search_systemtime As UInt64 = stop_search_system_time.ToFileTimeUtc()

            Dim i As UInt32 = m.WParam

            Dim psz_search_directory = "C:\SC290\CH" & (i + 1).ToString("D2") & "\"

            AMESDK.NET.EXPORTS.AMESDK_FILE_UPDATE_FILE_INFO_LIST(m_cSetupControl.m_cFileManagerControl.m_pFileInfoList(i), psz_search_directory, n_start_search_systemtime, n_stop_search_systemtime) '18446744073709551615 = &HFFFFFFFFFFFFFFFF

            m_cSetupControl.m_cFileManagerControl.Invalidate(True)

        End If

        MyBase.WndProc(m)

    End Sub

End Class
